using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;

[Serializable]
[Microsoft.SqlServer.Server.SqlUserDefinedType(Format.UserDefined, IsByteOrdered = true, MaxByteSize = 2)]
public struct Gender : INullable, IBinarySerialize
{
    private SqlString type_value;  // przechowuje warto typu
    private bool m_Null;

    public void Write(System.IO.BinaryWriter w)
    {
        // jeli typ ma warto null, zapisz do strumienia pusty string
        if (m_Null)
            w.Write("");
        // w przeciwnym wypadku zapisz do strumienia warto waciwoci type_value
        else
            w.Write(type_value.ToString());
    }
    public void Read(System.IO.BinaryReader r)
    {
        // przypisz do waciwoci type_value warto pobran ze strumienia
        type_value = r.ReadString().ToString();
    }

    public override string ToString()
    {
        // jeli typ ma warto null, zwr pusty string
        if (m_Null)
            return "";
        // w przeciwnym wypadku zwr warto waciwoci type_value
        else
            return type_value.ToString();
    }

    public bool IsNull
    {
        get
        {
            return m_Null; //zwrc warto waciwoci m_Null
        }
    }


    public static Gender Null
    {
        get
        {
            // zadeklaruj nowy obiekt Gender
            Gender h = new Gender();
            // ustaw waciwo m_null na true (jest null)
            h.m_Null = true;
            // zwr nowy obiekt
            return h;
        }
    }

    public static Gender Parse(SqlString s)
    {
        // jeli przekazana warto jest pusta, nie rb nic (zwr null)
        if (s.IsNull)
            return Null;
        
        // utwrz obiekt typu Gender
        Gender u = new Gender();
        // przypisz mu warto z parametru s
        u.Value = s;
        // zwr obiekt Gender
        return u;
    }

    public SqlString Value
    {
        // pobieranie wasciwoci
        get
        {
            // zwr warto waciwoci type_value
            return type_value;
        }

        // ustawianie wartoci waciwoci
        set 
        {
            // jesli przekazany paramater ma warto "K" lub "M"
            // to przypisz ja do waciwoci type_value
            if (value.Value.Equals("K") || value.Value.Equals("M"))
                type_value = value;

            // w przeciwnym wypadku rzu wyjtek
            else
                throw new ArgumentException("Dozwolone wartoci to K i M");
        }

    }
}


